# Database Setup Instructions

## Issue
The login is not working because there are no users in the database. You need to set up the database first.

## Solution Options

### Option 1: Install and Use MySQL (Recommended)

#### Step 1: Install MySQL
Download and install MySQL from one of these:
- **MySQL Community Server**: https://dev.mysql.com/downloads/mysql/
- **XAMPP** (includes MySQL, Apache, PHP): https://www.apachefriends.org/
- **Laragon** (lightweight): https://laragon.org/

#### Step 2: Start MySQL Service
- If using XAMPP: Open XAMPP Control Panel and start MySQL
- If using MySQL Service: 
  ```powershell
  Start-Service MySQL80
  ```

#### Step 3: Create Database
Open MySQL command line or phpMyAdmin and run:
```sql
CREATE DATABASE courier_cms;
```

Or using command line:
```powershell
mysql -u root -p -e "CREATE DATABASE courier_cms;"
```

#### Step 4: Run Migrations and Seed Data
```powershell
cd d:\download\project\laravel-cms
php artisan migrate:fresh --seed
```

This will create all tables and insert demo users.

### Option 2: Enable SQLite (Simpler, No MySQL needed)

#### Step 1: Enable SQLite Extension in PHP
1. Find your php.ini file (shown above):
   `C:\Users\Wasim\AppData\Local\Microsoft\WinGet\Packages\PHP.PHP.8.2_Microsoft.Winget.Source_8wekyb3d8bbwe\php.ini`

2. Open php.ini in a text editor (as Administrator)

3. Find this line and uncomment it (remove the semicolon):
   ```ini
   ;extension=sqlite3
   ```
   Change to:
   ```ini
   extension=sqlite3
   ```

4. Also uncomment:
   ```ini
   ;extension=pdo_sqlite
   ```
   Change to:
   ```ini
   extension=pdo_sqlite
   ```

5. Save and restart any running PHP processes

#### Step 2: Update .env File
Change in `.env`:
```env
DB_CONNECTION=sqlite
```

Comment out MySQL settings:
```env
# DB_HOST=127.0.0.1
# DB_PORT=3306
# DB_DATABASE=courier_cms
# DB_USERNAME=root
# DB_PASSWORD=
```

#### Step 3: Run Migrations
```powershell
php artisan config:clear
php artisan migrate:fresh --seed
```

## Demo Login Credentials (After Setup)

Once database is set up with seeders, you can login with:

### Seller Account
- **Email**: catherine@chicboutique.com
- **Password**: password

### Super Admin Account
- **Email**: admin@alwasisofttech.com
- **Password**: password

### Branch Operator Account
- **Email**: branch.multan@alwasisofttech.com
- **Password**: password

## Current Server Status

The Laravel development server is running on:
- **Port 8001**: http://localhost:8001/login

## Troubleshooting

### "Access denied for user 'root'@'localhost'"
Update the `.env` file with your MySQL password:
```env
DB_PASSWORD=your_mysql_password
```

### "Connection refused"
MySQL service is not running. Start it first.

### "Database doesn't exist"
Create the database using the SQL command above.
