# 🔐 Dummy Login Credentials

## Super Admin Accounts

### Account 1 (Primary)
```
Email: admin@admin.com
Password: password
Role: super-admin
```

### Account 2
```
Email: superadmin@example.com
Password: superadmin123
Role: super-admin
```

### Account 3 (Test)
```
Email: test@admin.com
Password: test123
Role: super-admin
```

---

## How to Seed Database

### Method 1: Run Specific Seeder
```bash
php artisan db:seed --class=SuperAdminSeeder
```

### Method 2: Run All Seeders
```bash
php artisan db:seed
```

### Method 3: Fresh Migration with Seed
```bash
php artisan migrate:fresh --seed
```

---

## Quick Login Steps

1. Navigate to: `http://your-domain.com/login`
2. Enter one of the credentials above
3. Click "Login"
4. You'll be redirected to the admin dashboard

---

## Super Admin Permissions

Super Admin accounts have full access to:
- ✅ All Finance & Accounting modules
- ✅ Branch Operations
- ✅ Marketing & Sales
- ✅ Support & Complaints
- ✅ Riders & Logistics
- ✅ System Settings & Control
- ✅ User Management
- ✅ All CRUD operations
- ✅ Reports & Analytics

---

## Security Notes

⚠️ **IMPORTANT FOR PRODUCTION:**

1. **Change all default passwords** before deploying to production
2. **Remove or disable** test accounts in production
3. **Use strong passwords** (minimum 12 characters with mixed case, numbers, symbols)
4. **Enable 2FA** for admin accounts
5. **Limit super admin accounts** to only necessary personnel

### Recommended Production Password Policy
```
Minimum length: 12 characters
Required: Uppercase, lowercase, numbers, symbols
Example: MyS3cur3P@ssw0rd!2024
```

---

## Troubleshooting

### Issue: Cannot login
**Solution:**
1. Verify database is seeded: `php artisan db:seed --class=SuperAdminSeeder`
2. Check user exists: `php artisan tinker` then `User::where('email', 'admin@admin.com')->first()`
3. Clear cache: `php artisan cache:clear`

### Issue: "User not approved"
**Solution:**
```bash
php artisan tinker
$user = User::where('email', 'admin@admin.com')->first();
$user->is_approved = true;
$user->save();
```

### Issue: Wrong role assigned
**Solution:**
```bash
php artisan tinker
$user = User::where('email', 'admin@admin.com')->first();
$user->role = 'super-admin';
$user->save();
$user->assignRole('Super Admin');
```

---

## Creating Additional Test Users

### Via Tinker
```php
php artisan tinker

use App\Models\User;
use Illuminate\Support\Facades\Hash;

$user = User::create([
    'name' => 'Your Name',
    'email' => 'your.email@example.com',
    'password' => Hash::make('your-password'),
    'role' => 'super-admin',
    'is_approved' => true,
]);

$user->assignRole('Super Admin');
```

### Via Seeder (Add to SuperAdminSeeder.php)
```php
[
    'name' => 'Your Name',
    'email' => 'your.email@example.com',
    'password' => 'your-password',
    'role' => 'super-admin',
],
```

---

## Other Role Examples

### Admin
```php
'role' => 'admin'
```

### Branch Manager
```php
'role' => 'branch-manager'
```

### Rider
```php
'role' => 'rider'
```

### Merchant
```php
'role' => 'merchant'
```

---

## Testing Checklist

- [ ] Login with Account 1 (admin@admin.com)
- [ ] Login with Account 2 (superadmin@example.com)
- [ ] Login with Account 3 (test@admin.com)
- [ ] Verify dashboard access
- [ ] Test all menu items
- [ ] Verify CRUD operations
- [ ] Test logout functionality
- [ ] Test password reset (if implemented)

---

**Last Updated:** 2025-10-03
**Environment:** Development/Testing Only
**Status:** ✅ Ready to Use
