# Installation Guide - Al-wasi Soft Tech CMS

## Quick Start Guide

Follow these steps to get the Laravel Courier Management System up and running on your local machine.

## Prerequisites

Before you begin, ensure you have the following installed:

- **PHP 8.1 or higher** - [Download PHP](https://www.php.net/downloads)
- **Composer** - [Download Composer](https://getcomposer.org/download/)
- **MySQL 5.7 or higher** - [Download MySQL](https://dev.mysql.com/downloads/)
- **Git** (optional) - [Download Git](https://git-scm.com/downloads)

### Verify PHP Installation

```bash
php -v
```

You should see PHP 8.1 or higher.

### Verify Composer Installation

```bash
composer -V
```

## Step-by-Step Installation

### 1. Navigate to Project Directory

```bash
cd d:/download/project/laravel-cms
```

### 2. Install PHP Dependencies

```bash
composer install
```

This will download all required Laravel packages and dependencies.

### 3. Create Environment File

```bash
# On Windows (PowerShell)
Copy-Item env.example .env

# On Windows (CMD)
copy env.example .env

# On Linux/Mac
cp env.example .env
```

### 4. Configure Database

Open the `.env` file in your text editor and update these lines:

```env
DB_CONNECTION=mysql
DB_HOST=127.0.0.1
DB_PORT=3306
DB_DATABASE=courier_cms
DB_USERNAME=root
DB_PASSWORD=your_mysql_password
```

Replace `your_mysql_password` with your actual MySQL password.

### 5. Create Database

Open MySQL command line or phpMyAdmin and create the database:

```sql
CREATE DATABASE courier_cms CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
```

Or using MySQL command line:

```bash
mysql -u root -p
```

Then:

```sql
CREATE DATABASE courier_cms;
EXIT;
```

### 6. Generate Application Key

```bash
php artisan key:generate
```

This will set the `APP_KEY` in your `.env` file.

### 7. Run Database Migrations

```bash
php artisan migrate
```

This creates all necessary tables in your database.

### 8. Seed Database with Sample Data

```bash
php artisan db:seed
```

This populates the database with:
- 7 user accounts (sellers, admins, branch operators)
- 7 sample parcels
- 3 branches
- 3 riders
- 3 complaints
- 3 news items

### 9. Create Storage Link (Optional)

```bash
php artisan storage:link
```

### 10. Start Development Server

```bash
php artisan serve
```

The application will be available at: **http://localhost:8000**

## Default Login Credentials

After seeding, you can login with these accounts:

### Seller Account
- **URL**: http://localhost:8000/login
- **Email**: catherine@chicboutique.com
- **Password**: password

### Super Admin Account
- **Email**: admin@alwasisofttech.com
- **Password**: password

### Branch Operator Account
- **Email**: branch.multan@alwasisofttech.com
- **Password**: password

### Finance Account
- **Email**: finance@alwasisofttech.com
- **Password**: password

## Troubleshooting

### Issue: "Class not found" errors

**Solution**: Run composer autoload dump
```bash
composer dump-autoload
```

### Issue: Database connection errors

**Solution**: 
1. Check MySQL is running
2. Verify credentials in `.env` file
3. Ensure database exists
4. Check MySQL port (default is 3306)

### Issue: Permission errors on Windows

**Solution**: Run command prompt as Administrator

### Issue: "No application encryption key has been specified"

**Solution**: Run key generation
```bash
php artisan key:generate
```

### Issue: Migration errors

**Solution**: Reset and re-run migrations
```bash
php artisan migrate:fresh --seed
```

**Warning**: This will delete all existing data!

## Accessing the Application

1. **Home Page**: http://localhost:8000
2. **Login**: http://localhost:8000/login
3. **Register**: http://localhost:8000/register
4. **Track Parcel**: Use tracking ID like "PCL162818" on home page

## Testing the Features

### As a Seller:
1. Login with seller credentials
2. Book a new parcel
3. View parcel list
4. Track parcel status
5. Submit a complaint

### As an Admin:
1. Login with admin credentials
2. View all parcels from all sellers
3. Update parcel status
4. Assign riders to parcels
5. Manage complaints

### As a Branch Operator:
1. Login with branch credentials
2. View branch dashboard
3. See assigned shipments
4. Track deliveries

## Next Steps

1. **Customize the application** - Modify views, add features
2. **Configure email** - Set up SMTP in `.env` for email notifications
3. **Add more data** - Create more users, parcels, branches
4. **Deploy to production** - Follow Laravel deployment guide

## Additional Commands

### Clear all caches
```bash
php artisan cache:clear
php artisan config:clear
php artisan route:clear
php artisan view:clear
```

### Reset database (Warning: Deletes all data)
```bash
php artisan migrate:fresh --seed
```

### Run on different port
```bash
php artisan serve --port=8080
```

## Support

If you encounter any issues:

1. Check Laravel logs: `storage/logs/laravel.log`
2. Enable debug mode: Set `APP_DEBUG=true` in `.env`
3. Review error messages carefully
4. Check PHP and MySQL versions

## Production Deployment

For production deployment, see the main README.md file for detailed instructions.

---

**Congratulations!** 🎉 Your Laravel Courier Management System is now installed and ready to use!
