# Al-wasi Soft Tech - Courier Management System (Laravel)

A comprehensive Cash on Delivery (COD) Courier Management System built with PHP Laravel. This system manages the entire logistics workflow from booking to delivery, including parcel tracking, rider management, branch operations, and financial reconciliation.

## Features

### For Sellers
- **Parcel Booking**: Book single or bulk parcels with detailed information
- **Real-time Tracking**: Track parcels from pickup to delivery
- **Wallet Management**: View COD collections and request payouts
- **Complaint Management**: Submit and track complaints
- **Dashboard Analytics**: View delivery statistics and performance metrics

### For Admins
- **Complete System Overview**: Monitor all operations across branches
- **Parcel Management**: Assign riders, update statuses, manage deliveries
- **Branch Operations**: Manage multiple branches and their operations
- **Rider Management**: Track rider performance and assignments
- **Financial Management**: COD reconciliation, payouts, and accounting
- **Complaint Resolution**: Handle and resolve customer complaints

### For Branch Operators
- **Branch Dashboard**: View branch-specific operations
- **Delivery Management**: Manage pickups, deliveries, and returns
- **Rider Coordination**: Assign and track riders
- **COD Collection**: Track cash collections and deposits

## Technology Stack

- **Backend**: PHP 8.1+, Laravel 10
- **Database**: MySQL
- **Frontend**: Blade Templates, Tailwind CSS
- **Authentication**: Laravel Sanctum

## Installation

### Prerequisites
- PHP 8.1 or higher
- Composer
- MySQL 5.7 or higher
- Node.js & NPM (optional, for asset compilation)

### Setup Instructions

1. **Clone the repository**
   ```bash
   cd laravel-cms
   ```

2. **Install PHP dependencies**
   ```bash
   composer install
   ```

3. **Environment Configuration**
   ```bash
   cp env.example .env
   ```
   
   Update the `.env` file with your database credentials:
   ```
   DB_CONNECTION=mysql
   DB_HOST=127.0.0.1
   DB_PORT=3306
   DB_DATABASE=courier_cms
   DB_USERNAME=root
   DB_PASSWORD=your_password
   ```

4. **Generate Application Key**
   ```bash
   php artisan key:generate
   ```

5. **Create Database**
   Create a MySQL database named `courier_cms`:
   ```sql
   CREATE DATABASE courier_cms;
   ```

6. **Run Migrations**
   ```bash
   php artisan migrate
   ```

7. **Seed Database with Sample Data**
   ```bash
   php artisan db:seed
   ```

8. **Start Development Server**
   ```bash
   php artisan serve
   ```

   The application will be available at `http://localhost:8000`

## Default Login Credentials

After seeding the database, you can login with these accounts:

### Seller Account
- **Email**: catherine@chicboutique.com
- **Password**: password

### Super Admin Account
- **Email**: admin@alwasisofttech.com
- **Password**: password

### Branch Operator Account
- **Email**: branch.multan@alwasisofttech.com
- **Password**: password

### Finance Account
- **Email**: finance@alwasisofttech.com
- **Password**: password

## Database Schema

### Main Tables
- **users**: User accounts with role-based access
- **parcels**: Parcel/shipment information
- **riders**: Delivery riders
- **branches**: Branch locations
- **complaints**: Customer complaints
- **payouts**: Seller payouts
- **news**: System announcements

### User Roles
- `seller`: E-commerce sellers who book parcels
- `super-admin`: Full system access
- `admin`: Administrative access
- `branch-operator`: Branch-level operations
- `finance`: Financial operations
- `finance-manager`: Finance team lead
- `marketing`: Marketing team
- `marketing-manager`: Marketing team lead
- `support`: Customer support
- `rider-manager`: Rider operations manager
- `hr`: Human resources

## Key Features Explained

### Parcel Tracking
Each parcel gets a unique tracking ID (e.g., PCL162818) that can be tracked publicly without login.

### Status Flow
1. **Pending**: Parcel booked, awaiting pickup
2. **Picked Up**: Rider has collected the parcel
3. **In Transit**: Parcel is being transported
4. **Out for Delivery**: Rider is delivering to customer
5. **Delivered**: Successfully delivered
6. **Failed**: Delivery attempt failed
7. **Returned**: Returned to seller

### COD Management
- Automatic calculation of COD amounts
- Wallet system for sellers
- Payout requests and tracking
- Financial reconciliation tools

## API Routes

### Public Routes
- `GET /` - Landing page
- `POST /track` - Track parcel by ID
- `GET /login` - Login page
- `GET /register` - Registration page

### Seller Routes (Authenticated)
- `GET /seller/dashboard` - Seller dashboard
- `GET /seller/parcels` - List all parcels
- `POST /seller/parcels` - Book new parcel
- `GET /seller/parcels/{id}` - View parcel details
- `GET /seller/complaints` - List complaints
- `POST /seller/complaints` - Submit complaint

### Admin Routes (Authenticated)
- `GET /admin/dashboard` - Admin dashboard
- `GET /admin/parcels` - Manage all parcels
- `PATCH /admin/parcels/{id}` - Update parcel status
- `GET /admin/complaints` - Manage complaints

### Branch Routes (Authenticated)
- `GET /admin/branch/dashboard` - Branch dashboard

## Development

### Running Tests
```bash
php artisan test
```

### Code Style
Follow PSR-12 coding standards:
```bash
./vendor/bin/pint
```

### Database Refresh
To reset the database and reseed:
```bash
php artisan migrate:fresh --seed
```

## Production Deployment

1. Set `APP_ENV=production` and `APP_DEBUG=false` in `.env`
2. Run `php artisan config:cache`
3. Run `php artisan route:cache`
4. Run `php artisan view:cache`
5. Set up proper web server (Apache/Nginx)
6. Configure SSL certificate
7. Set up database backups
8. Configure queue workers for background jobs

## File Structure

```
laravel-cms/
├── app/
│   ├── Http/
│   │   ├── Controllers/
│   │   └── Middleware/
│   └── Models/
├── database/
│   ├── migrations/
│   └── seeders/
├── resources/
│   └── views/
│       ├── auth/
│       ├── seller/
│       ├── admin/
│       ├── parcels/
│       └── layouts/
├── routes/
│   └── web.php
└── public/
```

## Support

For issues or questions, please contact:
- Email: support@alwasisofttech.com
- Website: https://alwasisofttech.com

## License

This project is proprietary software owned by Al-wasi Soft Tech.

## Changelog

### Version 1.0.0 (2024)
- Initial release
- User authentication and authorization
- Parcel booking and tracking
- Multi-role dashboard system
- Complaint management
- Basic reporting

---

**Note**: This is a conversion from the original Next.js/TypeScript application to PHP Laravel. All core features have been implemented with Laravel best practices.
