<?php

namespace App\Http\Controllers\Admin\Branch\Operation;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class OperationController extends Controller
{
    public function index()
    {
        return view('admin.branch.operation.index');
    }

    public function deliveriesAssigned()
    {
        // Placeholder data
        $assignedDeliveries = collect([
            ['id' => 1, 'tracking_number' => 'PN-123456', 'rider' => 'John Doe', 'status' => 'Out for Delivery'],
            ['id' => 2, 'tracking_number' => 'PN-789012', 'rider' => 'Jane Smith', 'status' => 'Out for Delivery'],
            ['id' => 3, 'tracking_number' => 'PN-345678', 'rider' => 'John Doe', 'status' => 'Pending'],
        ]);

        return view('admin.branch.operation.deliveries-assigned', compact('assignedDeliveries'));
    }

    public function successfulDeliveries()
    {
        // Placeholder data
        $successfulDeliveries = collect([
            ['id' => 1, 'tracking_number' => 'PN-112233', 'rider' => 'John Doe', 'delivered_at' => '2023-10-27 14:30'],
            ['id' => 2, 'tracking_number' => 'PN-445566', 'rider' => 'Jane Smith', 'delivered_at' => '2023-10-27 15:00'],
        ]);

        return view('admin.branch.operation.successful-deliveries', compact('successfulDeliveries'));
    }
}
