<?php

namespace App\Http\Controllers\Admin\Finance\Expense;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\RecurringExpense;

class RecurringExpenseController extends Controller
{
    public function store(Request $request)
    {
        $request->validate([
            'title' => 'required|string|max:255',
            'amount' => 'required|numeric|min:0',
            'frequency' => 'required|in:daily,weekly,monthly,yearly',
            'start_date' => 'required|date',
            'end_date' => 'nullable|date|after_or_equal:start_date',
            'category' => 'required|string|max:255',
            'vendor_id' => 'nullable|exists:vendors,id',
        ]);

        RecurringExpense::create($request->all());

        return redirect()->route('admin.finance.expenses.recurring')->with('success', 'Recurring expense created successfully.');
    }
}
