<?php

namespace App\Http\Controllers\Admin\Finance\Payroll;

use App\Http\Controllers\Controller;
use App\Models\TaxDeduction;
use Illuminate\Http\Request;

class TaxDeductionController extends Controller
{
    public function store(Request $request)
    {
        $validated = $request->validate([
            'employee_id' => 'required|exists:employees,id',
            'month' => 'required|date_format:Y-m',
            'amount' => 'required|numeric|min:0',
            'type' => 'required|string',
            'description' => 'nullable|string',
        ]);

        TaxDeduction::create($validated);

        return redirect()->route('admin.finance.payroll.tax-deductions')->with('success', 'Tax deduction added successfully.');
    }
}
