<?php

namespace App\Http\Controllers\Admin\Finance;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class SettlementController extends Controller
{
    public function invoices()
    {
        return view('admin.finance.settlements.invoices.index');
    }

    public function createInvoice()
    {
        return view('admin.finance.settlements.invoices.create');
    }

    public function storeInvoice(Request $request)
    {
        return redirect()->route('admin.finance.settlements.invoices')
            ->with('success', 'Invoice created successfully!');
    }

    public function showInvoice($id)
    {
        return view('admin.finance.settlements.invoices.show');
    }

    public function editInvoice($id)
    {
        return view('admin.finance.settlements.invoices.edit');
    }

    public function updateInvoice(Request $request, $id)
    {
        return redirect()->route('admin.finance.settlements.invoices')
            ->with('success', 'Invoice updated successfully!');
    }

    public function destroyInvoice($id)
    {
        return redirect()->route('admin.finance.settlements.invoices')
            ->with('success', 'Invoice deleted successfully!');
    }

    public function payments()
    {
        return view('admin.finance.settlements.payments.index');
    }

    public function processPayment(Request $request)
    {
        return back()->with('success', 'Payment processed successfully!');
    }

    public function deductions()
    {
        return view('admin.finance.settlements.deductions.index');
    }

    public function pendingReport()
    {
        return view('admin.finance.settlements.pending-report');
    }

    public function disputes()
    {
        return view('admin.finance.settlements.disputes.index');
    }

    public function resolveDispute(Request $request, $id)
    {
        return back()->with('success', 'Dispute resolved successfully!');
    }
}
