<?php

namespace App\Http\Controllers\Admin\HR;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Employee;
use App\Models\Branch;

class AttendanceController extends Controller
{
    protected function commonData(): array
    {
        $employeeCount = Employee::count();
        $branchCount = Branch::count();
        $recentEmployees = Employee::orderBy('created_at', 'desc')->take(5)->get();
        return [
            'employeeCount' => $employeeCount,
            'branchCount' => $branchCount,
            'recentEmployees' => $recentEmployees,
        ];
    }

    /**
     * Attendance Management dashboard.
     */
    public function index()
    {
        $data = $this->commonData();
        return view('admin.hr.attendance', $data);
    }

    /**
     * Mark attendance for an employee (stub implementation).
     */
    public function mark(Request $request)
    {
        $validated = $request->validate([
            'employee_id' => 'required|integer',
            'status' => 'required|string|in:present,absent,late',
            'date' => 'nullable|date',
        ]);

        // Placeholder: persist attendance record in future.
        return back()->with('status', 'Attendance marked: ' . $validated['status']);
    }

    /**
     * Leave Management listing.
     */
    public function leaves()
    {
        $data = $this->commonData();
        return view('admin.hr.leave', $data);
    }

    /**
     * Apply for leave (stub implementation).
     */
    public function applyLeave(Request $request)
    {
        $validated = $request->validate([
            'employee_id' => 'required|integer',
            'type' => 'required|string|max:100',
            'from' => 'required|date',
            'to' => 'required|date|after_or_equal:from',
        ]);

        // Placeholder: persist leave request in future.
        return back()->with('status', 'Leave request submitted for ' . $validated['employee_id']);
    }
}