<?php

namespace App\Http\Controllers\Admin\HR;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Employee;
use App\Models\Branch;

class ExitController extends Controller
{
    protected function commonData(): array
    {
        $employeeCount = class_exists(Employee::class) ? (Employee::count() ?? 0) : 0;
        $branchCount = class_exists(Branch::class) ? (Branch::count() ?? 0) : 0;
        $recentEmployees = class_exists(Employee::class)
            ? Employee::latest()->take(5)->get()
            : collect([
                (object) ['id' => 1, 'name' => 'John Doe', 'position' => 'Accountant'],
                (object) ['id' => 2, 'name' => 'Jane Smith', 'position' => 'HR Executive'],
                (object) ['id' => 3, 'name' => 'Alex Johnson', 'position' => 'Support Lead'],
            ]);

        return compact('employeeCount', 'branchCount', 'recentEmployees');
    }

    public function index()
    {
        $data = $this->commonData();
        return view('admin.hr.exit', $data + [
            'pageTitle' => 'Exit & Handover',
        ]);
    }

    public function process(Request $request)
    {
        $validated = $request->validate([
            'employee_id' => 'required|integer',
            'last_day' => 'required|date',
            'reason' => 'nullable|string',
            'handover_notes' => 'nullable|string',
            'documents_collected' => 'nullable|boolean',
        ]);

        // Here you would persist the exit record, trigger notifications, etc.

        return redirect()->back()->with('status', 'Exit & handover processed successfully.');
    }
}