<?php

namespace App\Http\Controllers\Admin\HR;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Employee;
use App\Models\Branch;

class PerformanceController extends Controller
{
    protected function commonData(): array
    {
        $employeeCount = Employee::count();
        $branchCount = Branch::count();
        $recentEmployees = Employee::orderBy('created_at', 'desc')->take(5)->get();
        return [
            'employeeCount' => $employeeCount,
            'branchCount' => $branchCount,
            'recentEmployees' => $recentEmployees,
        ];
    }

    /**
     * Performance KPIs dashboard.
     */
    public function kpis()
    {
        $data = $this->commonData();
        return view('admin.hr.performance', $data);
    }

    /**
     * Store or submit a performance review (stub).
     */
    public function storeReview(Request $request)
    {
        $validated = $request->validate([
            'employee_id' => 'required|integer',
            'rating' => 'required|integer|min:1|max:5',
            'notes' => 'nullable|string|max:1000',
        ]);

        // Placeholder: persist performance review in future.
        return back()->with('status', 'Performance review saved for employee ' . $validated['employee_id']);
    }
}