<?php

namespace App\Http\Controllers\Admin\HR;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Employee;
use App\Models\Branch;

class RecruitmentController extends Controller
{
    /**
     * Provide common stats for HR pages.
     */
    protected function commonData(): array
    {
        $employeeCount = Employee::count();
        $branchCount = Branch::count();
        $recentEmployees = Employee::orderBy('created_at', 'desc')->take(5)->get();

        return [
            'employeeCount' => $employeeCount,
            'branchCount' => $branchCount,
            'recentEmployees' => $recentEmployees,
        ];
    }

    /**
     * Recruitment & Hiring dashboard.
     */
    public function index()
    {
        $data = $this->commonData();
        return view('admin.hr.recruitment', $data);
    }

    /**
     * Handle basic recruitment request submission.
     */
    public function store(Request $request)
    {
        $validated = $request->validate([
            'position' => 'nullable|string|max:255',
            'department' => 'nullable|string|max:255',
            'openings' => 'nullable|integer|min:1',
        ]);

        // Placeholder: In future, persist recruitment request model.
        return back()->with('status', 'Recruitment request received.');
    }
}