<?php

namespace App\Http\Controllers\Admin\HR;

use App\Http\Controllers\Controller;
use App\Models\Employee;
use App\Models\Branch;

class TrainingController extends Controller
{
    protected function commonData(): array
    {
        $employeesCount = Employee::query()->count();
        $branchesCount  = Branch::query()->count();
        $recentEmployees = Employee::query()->latest()->limit(6)->get();
        return compact('employeesCount', 'branchesCount', 'recentEmployees');
    }

    public function index()
    {
        return view('admin.hr.training', $this->commonData());
    }

    public function documents()
    {
        return view('admin.hr.documents', $this->commonData());
    }
}