<?php

namespace App\Http\Controllers\Admin\Marketing\CRM;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Lead;
use App\Models\Territory;
use App\Models\User;

class CRMController extends Controller
{
    public function index()
    {
        return view('admin.marketing.crm.index');
    }

    public function leadManagement()
    {
        $leads = Lead::with('territory')->latest()->paginate(15);
        return view('admin.marketing.crm.leadManagement', compact('leads'));
    }

    public function territoryMapping()
    {
        $territories = Territory::withCount('leads')->get();
        return view('admin.marketing.crm.territoryMapping', compact('territories'));
    }

    public function targetAchievement()
    {
        $territories = Territory::with('leads')->get();
        $stats = [
            'total_target' => $territories->sum('target_amount'),
            'achieved' => Lead::where('status', 'converted')->sum('value'),
            'pending' => Lead::whereIn('status', ['new', 'contacted', 'qualified'])->sum('value'),
        ];
        return view('admin.marketing.crm.targetAchievement', compact('territories', 'stats'));
    }

    public function pipelineTracker()
    {
        $pipeline = [
            'new' => Lead::where('status', 'new')->count(),
            'contacted' => Lead::where('status', 'contacted')->count(),
            'qualified' => Lead::where('status', 'qualified')->count(),
            'converted' => Lead::where('status', 'converted')->count(),
            'lost' => Lead::where('status', 'lost')->count(),
        ];
        $leads = Lead::latest()->take(20)->get();
        return view('admin.marketing.crm.pipelineTracker', compact('pipeline', 'leads'));
    }

    public function merchantRanking()
    {
        $merchants = User::where('role', 'seller')
            ->withCount('parcels')
            ->orderBy('parcels_count', 'desc')
            ->take(20)
            ->get();
        return view('admin.marketing.crm.merchantRanking', compact('merchants'));
    }
}
