<?php

namespace App\Http\Controllers\Admin\Marketing;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class LeadController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $leads = \App\Models\Lead::all();
        return view('admin.marketing.leads.index', compact('leads'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('admin.marketing.leads.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'company_name' => 'required|string|max:255',
            'contact_person' => 'required|string|max:255',
            'email' => 'required|email|max:255',
            'phone' => 'required|string|max:255',
            'status' => 'required|string|in:Prospect,Demo,Onboard,Active',
            'user_id' => 'required|exists:users,id',
            'notes' => 'nullable|string',
            'value' => 'nullable|numeric|min:0',
        ]);

        \App\Models\Lead::create($request->all());

        return redirect()->route('admin.marketing.leads.index')->with('success', 'Lead created successfully.');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        $lead = \App\Models\Lead::findOrFail($id);
        return view('admin.marketing.leads.edit', compact('lead'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        $request->validate([
            'company_name' => 'required|string|max:255',
            'contact_person' => 'required|string|max:255',
            'email' => 'required|email|max:255',
            'phone' => 'required|string|max:255',
            'status' => 'required|string|in:Prospect,Demo,Onboard,Active',
            'user_id' => 'required|exists:users,id',
            'notes' => 'nullable|string',
            'value' => 'nullable|numeric|min:0',
        ]);

        $lead = \App\Models\Lead::findOrFail($id);
        $lead->update($request->all());

        return redirect()->route('admin.marketing.leads.index')->with('success', 'Lead updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        $lead = \App\Models\Lead::findOrFail($id);
        $lead->delete();

        return redirect()->route('admin.marketing.leads.index')->with('success', 'Lead deleted successfully.');
    }
}
