<?php

namespace App\Http\Controllers\Admin\Marketing;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Territory;
use App\Models\Parcel;

class ProfileController extends Controller
{
    public function hierarchy()
    {
        $territories = Territory::with('manager')->get();
        return view('admin.marketing.profile.hierarchy', compact('territories'));
    }

    public function walletStatus()
    {
        $merchants = User::where('role', 'seller')->get();
        return view('admin.marketing.profile.walletStatus', compact('merchants'));
    }

    public function shipmentSummary()
    {
        // Assuming 'merchant' is the relationship on the Parcel model to the User model.
        $shipments = Parcel::with('merchant')->latest()->get();
        return view('admin.marketing.profile.shipmentSummary', compact('shipments'));
    }
}
