<?php

namespace App\Http\Controllers\Admin\Rider\Finance;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Rider;
use App\Models\Parcel;

class FinanceController extends Controller
{
    public function cashCollection()
    {
        $riders = Rider::with(['parcels' => function($query) {
            $query->where('status', 'Delivered')->whereNotNull('cod_amount');
        }])->get();

        return view('admin.rider.finance.cash-collection', compact('riders'));
    }

    public function pendingCOD()
    {
        $pendingCOD = Parcel::where('status', 'Delivered')
            ->whereNotNull('cod_amount')
            ->where('is_scanned', false)
            ->with('rider')
            ->get();

        return view('admin.rider.finance.pending-cod', compact('pendingCOD'));
    }

    public function discrepancy()
    {
        $discrepancies = Parcel::where('status', 'Delivered')
            ->whereNotNull('cod_amount')
            ->whereColumn('cod_amount', '!=', 'collected_amount')
            ->with('rider')
            ->get();

        return view('admin.rider.finance.discrepancy', compact('discrepancies'));
    }
}
