<?php

namespace App\Http\Controllers\Admin\Rider\Operation;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Rider;
use App\Models\Parcel;

class OperationController extends Controller
{
    public function assignParcels()
    {
        $riders = Rider::where('status', 'active')->get();
        $availableParcels = Parcel::whereIn('status', ['Pending', 'Ready for Pickup'])->get();

        return view('admin.rider.operation.assign-parcels', compact('riders', 'availableParcels'));
    }

    public function storeAssignment(Request $request)
    {
        $request->validate([
            'rider_id' => 'required|exists:riders,id',
            'parcel_ids' => 'required|array',
            'parcel_ids.*' => 'exists:parcels,id',
        ]);

        foreach ($request->parcel_ids as $parcelId) {
            $parcel = Parcel::find($parcelId);
            $parcel->update([
                'assigned_rider_id' => $request->rider_id,
                'status' => 'Assigned',
            ]);
        }

        return redirect()->route('admin.riders.assign-parcels')->with('success', 'Parcels assigned successfully.');
    }
}
