<?php

namespace App\Http\Controllers\Admin\Rider\Performance;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Rider;

class PerformanceController extends Controller
{
    public function efficiency()
    {
        $riders = Rider::withCount(['parcels as delivered_count' => function($query) {
            $query->where('status', 'Delivered');
        }])->withCount(['parcels as total_parcels'])->get();

        return view('admin.rider.performance.efficiency', compact('riders'));
    }

    public function handover()
    {
        $riders = Rider::with(['parcels' => function($query) {
            $query->whereIn('status', ['Picked Up', 'Out for Delivery'])->latest();
        }])->get();

        return view('admin.rider.performance.handover', compact('riders'));
    }

    public function topRiders()
    {
        $topRiders = Rider::withCount(['parcels as delivered_count' => function($query) {
            $query->where('status', 'Delivered');
        }])->orderBy('delivered_count', 'desc')->take(10)->get();

        return view('admin.rider.performance.top-riders', compact('topRiders'));
    }
}
