<?php

namespace App\Http\Controllers\Admin\Rider\Profile;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Rider;

class ProfileController extends Controller
{
    public function index()
    {
        $totalRiders = Rider::count();
        $activeRiders = Rider::where('status', 'active')->count();
        $ridersOnDuty = Rider::whereHas('parcels', function($query) {
            $query->whereIn('status', ['Picked Up', 'Out for Delivery']);
        })->count();
        return view('admin.rider.profile.index', compact(
            'totalRiders', 'activeRiders', 'ridersOnDuty'
        ));
    }

    /**
     * Rider Attendance overview.
     */
    public function attendance()
    {
        $totalRiders = Rider::count();
        $onDutyCount = Rider::whereHas('parcels', function($query) {
            $query->whereIn('status', ['Picked Up', 'Out for Delivery']);
        })->count();
        $availableCount = $totalRiders - $onDutyCount;

        $riders = Rider::with(['parcels' => function($query) {
            $query->latest()->take(5);
        }])->latest()->paginate(15);

        return view('admin.rider.profile.attendance', compact(
            'totalRiders', 'onDutyCount', 'availableCount', 'riders'
        ));
    }

    public function gpsTracking()
    {
        // Placeholder data
        $riders = collect([
            ['id' => 1, 'name' => 'John Doe', 'lat' => 34.0522, 'lng' => -118.2437, 'status' => 'On-duty'],
            ['id' => 2, 'name' => 'Jane Smith', 'lat' => 36.1699, 'lng' => -115.1398, 'status' => 'On-duty'],
            ['id' => 3, 'name' => 'Mike Johnson', 'lat' => 40.7128, 'lng' => -74.0060, 'status' => 'Off-duty'],
        ]);

        return view('admin.rider.profile.gps-tracking', compact('riders'));
    }
}
