<?php

namespace App\Http\Controllers\Admin\Support;

use App\Http\Controllers\Controller;
use App\Models\SupportTicket;
use Illuminate\Http\Request;

class SupportController extends Controller
{
    public function dashboard()
    {
        return view('admin.support.dashboard');
    }

    public function tickets()
    {
        $tickets = SupportTicket::with(['user', 'assignedUser'])
            ->latest()
            ->paginate(20);

        $stats = [
            'total' => SupportTicket::count(),
            'open' => SupportTicket::where('status', 'open')->count(),
            'pending' => SupportTicket::where('status', 'pending')->count(),
            'resolved' => SupportTicket::where('status', 'resolved')->count(),
            'overdue' => SupportTicket::where('sla_deadline', '<', now())->count(),
        ];

        return view('admin.support.tickets', compact('tickets', 'stats'));
    }

    public function open()
    {
        $tickets = SupportTicket::with(['user', 'assignedUser'])
            ->where('status', 'open')
            ->latest()
            ->paginate(20);

        return view('admin.support.tickets.open', compact('tickets'));
    }

    public function pending()
    {
        $tickets = SupportTicket::with(['user', 'assignedUser'])
            ->where('status', 'pending')
            ->latest()
            ->paginate(20);

        return view('admin.support.tickets.pending', compact('tickets'));
    }

    public function resolved()
    {
        $tickets = SupportTicket::with(['user', 'assignedUser'])
            ->where('status', 'resolved')
            ->latest()
            ->paginate(20);

        return view('admin.support.tickets.resolved', compact('tickets'));
    }

    public function escalated()
    {
        $tickets = SupportTicket::with(['user', 'assignedUser'])
            ->where('status', 'escalated')
            ->latest()
            ->paginate(20);

        return view('admin.support.tickets.escalated', compact('tickets'));
    }

    public function categories()
    {
        $categories = [
            'technical' => SupportTicket::where('category', 'technical')->count(),
            'billing' => SupportTicket::where('category', 'billing')->count(),
            'shipping' => SupportTicket::where('category', 'shipping')->count(),
            'complaint' => SupportTicket::where('category', 'complaint')->count(),
            'feature_request' => SupportTicket::where('category', 'feature_request')->count(),
            'other' => SupportTicket::where('category', 'other')->count(),
        ];

        return view('admin.support.tickets.categories', compact('categories'));
    }

    public function sla()
    {
        $slaStats = [
            'within_sla' => SupportTicket::whereColumn('resolved_at', '<=', 'sla_deadline')
                ->whereNotNull('resolved_at')
                ->count(),
            'breached_sla' => SupportTicket::whereColumn('resolved_at', '>', 'sla_deadline')
                ->whereNotNull('resolved_at')
                ->count(),
            'overdue' => SupportTicket::where('sla_deadline', '<', now())
                ->where('status', '!=', 'resolved')
                ->count(),
            'total' => SupportTicket::count(),
        ];

        return view('admin.support.tickets.sla', compact('slaStats'));
    }
}
