<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\MerchantInvoice;
use App\Models\MerchantPayment;
use App\Models\Expense;

class FinanceDataController extends Controller
{
    public function dashboardData(Request $request)
    {
        // Mock data for now, to be replaced with real queries
        $stats = [
            'total_deliveries' => 125,
            'cod_collected' => 25000,
            'deposits' => 15000,
            'variance' => 10000,
        ];

        $agentWallets = [
          ['agent' => 'Agent 1', 'balance' => 500, 'cleared' => true, 'action' => 'Mark Deposited'],
          ['agent' => 'Agent 2', 'balance' => 1000, 'cleared' => false, 'action' => 'Not anot'],
          ['agent' => 'Agent 3', 'balance' => 0, 'cleared' => false, 'action' => 'Not anot'],
        ];

        $ledgers = [
          ['date' => '2024-01-01', 'agent' => 'Agent 1', 'amount' => 500, 'status' => 'Deposited'],
          ['date' => '2024-01-02', 'agent' => 'Agent 2', 'amount' => 1000, 'status' => 'Pending'],
          ['date' => '2024-01-03', 'agent' => 'Agent 3', 'amount' => 50, 'status' => 'Pending'],
        ];

        $auditTrail = [
            ['activity' => 'Collected', 'amount' => 500, 'date' => '2024-01-01 10:00 AM'],
            ['activity' => 'Deposited', 'amount' => 500, 'date' => '2024-01-01 10:00 AM'],
            ['activity' => 'Marked as collected', 'amount' => 50, 'date' => '2024-01-01 10:00 AM'],
        ];

        return response()->json([
            'stats' => $stats,
            'agentWallets' => $agentWallets,
            'ledgers' => $ledgers,
            'auditTrail' => $auditTrail,
        ]);
    }
}
