<?php

namespace App\Http\Controllers\Branch;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Parcel;
use App\Models\Rider;
use Illuminate\Support\Facades\Auth;

class DispatchShipmentsController extends Controller
{
    public function index()
    {
        $dispatchableShipments = Parcel::where('status', 'Received at Hub')
                                        ->where('branch_id', Auth::user()->branch_id)
                                        ->with('seller')
                                        ->latest()
                                        ->paginate(20);

        $riders = Rider::where('branch_id', Auth::user()->branch_id)->get();

        return view('branch.dispatch-shipments', compact('dispatchableShipments', 'riders'));
    }

    public function assignRider(Request $request, Parcel $parcel)
    {
        $request->validate([
            'rider_id' => 'required|exists:riders,id',
        ]);

        $parcel->update([
            'assigned_rider_id' => $request->rider_id,
            'status' => 'Out for Delivery',
        ]);

        return back()->with('success', 'Rider assigned successfully.');
    }
}
