<?php

namespace App\Http\Controllers\Branch;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Parcel;
use Illuminate\Support\Facades\Auth;

class PickupOrdersController extends Controller
{
    public function index()
    {
        $pickupOrders = Parcel::where('status', 'Pending Pickup')
                               ->where('branch_id', Auth::user()->branch_id)
                               ->with('seller')
                               ->latest()
                               ->paginate(20);

        return view('branch.pickup-orders', compact('pickupOrders'));
    }

    public function markAsPickedUp(Parcel $parcel)
    {
        $parcel->update(['status' => 'Picked Up']);

        return back()->with('success', 'Parcel marked as picked up.');
    }
}
