<?php

namespace App\Http\Controllers\Branch;

use App\Http\Controllers\Controller;
use App\Models\Parcel;
use Illuminate\Http\Request;

class ReceiveShipmentsController extends Controller
{
    public function index()
    {
        return view('branch.receive-shipments');
    }

    public function scan(Request $request)
    {
        $request->validate([
            'tracking_id' => 'required|exists:parcels,tracking_id',
        ]);

        $parcel = Parcel::where('tracking_id', $request->tracking_id)->firstOrFail();
        $parcel->update(['status' => 'Received at Hub']);

        return response()->json(['success' => 'Shipment received.', 'parcel' => $parcel]);
    }
}
