<?php

namespace App\Http\Controllers\Branch;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Parcel;
use Illuminate\Support\Facades\Auth;

class SuccessfulDeliveriesController extends Controller
{
    public function index()
    {
        $successfulDeliveries = Parcel::where('status', 'Delivered')
                                        ->where('branch_id', Auth::user()->branch_id)
                                        ->with('seller', 'rider')
                                        ->latest()
                                        ->paginate(20);

        return view('branch.successful-deliveries', compact('successfulDeliveries'));
    }
}
