<?php

namespace App\Http\Controllers\Branch;

use App\Http\Controllers\Controller;
use App\Models\Bag;
use Illuminate\Http\Request;

class UnbaggingController extends Controller
{
    public function index()
    {
        return view('branch.unbagging');
    }

    public function findBag(Request $request)
    {
        $request->validate([
            'bag_seal_number' => 'required|exists:bags,bag_number',
        ]);

        $bag = Bag::where('bag_number', $request->bag_seal_number)
                    ->with('parcels', 'originBranch', 'destinationBranch')
                    ->firstOrFail();

        return response()->json(['success' => 'Bag found.', 'bag' => $bag]);
    }

    public function receiveBag(Bag $bag)
    {
        $bag->update(['status' => 'received']);

        // You might want to update the status of each parcel in the bag as well.
        // For example: $bag->parcels()->update(['status' => 'Received at Hub']);

        return response()->json(['success' => 'Bag marked as received.']);
    }
}
