<?php

namespace App\Http\Controllers\Seller;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\Order;
use App\Models\Complaint;

class DashboardController extends Controller
{
    public function sellerDashboard(Request $request)
    {
        $user = Auth::user();

        $query = Order::where('user_id', $user->id);

        // Date filtering
        if ($request->filled('from_date')) {
            $query->whereDate('created_at', '>=', $request->get('from_date'));
        }
        if ($request->filled('to_date')) {
            $query->whereDate('created_at', '<=', $request->get('to_date'));
        }

        // Top cards data
        $walletBalance = 1500; // Placeholder
        $todaysBooked = (clone $query)->whereDate('created_at', today())->count();
        $deliveredParcels = (clone $query)->where('status', 'Delivered')->count();
        $returnedParcels = (clone $query)->where('status', 'Returned')->count();

        // Order Status Overview data
        $totalParcels = (clone $query)->count();

        // Recent Orders table
        $recentParcels = (clone $query)->latest()->take(5)->get();

        // My Complaints card
        $recentComplaints = Complaint::where('user_id', $user->id)->latest()->take(3)->get();

        return view('seller.dashboard', compact(
            'walletBalance',
            'todaysBooked',
            'deliveredParcels',
            'returnedParcels',
            'totalParcels',
            'recentParcels',
            'recentComplaints'
        ));
    }
}
