<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class RedirectIfAuthenticated
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next, string ...$guards): Response
    {
        $guards = empty($guards) ? [null] : $guards;

        foreach ($guards as $guard) {
            if (Auth::guard($guard)->check()) {
                $user = Auth::user();
                
                // Use canonical Spatie role names (case-sensitive)
                if ($user->hasAnyRole(['Admin', 'Super Admin'])) {
                    return redirect('/admin/dashboard');
                } elseif ($user->hasRole('Branch Operator')) {
                    return redirect('/admin/branch/dashboard');
                } else {
                    return redirect('/seller/dashboard');
                }
            }
        }

        return $next($request);
    }
}
