<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Bag extends Model
{
    use HasFactory;

    protected $fillable = [
        'bag_number',
        'status',
        'rider_id',
        'origin_branch_id',
        'destination_branch_id',
    ];

    public function items()
    {
        return $this->hasMany(BagItem::class);
    }

    public function parcels()
    {
        return $this->belongsToMany(Parcel::class, 'bag_items');
    }

    public function destinationBranch()
    {
        return $this->belongsTo(Branch::class, 'destination_branch_id');
    }

    public function rider()
    {
        return $this->belongsTo(Rider::class);
    }
}
