<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Bank extends Model
{
    use HasFactory;

    protected $fillable = [
        'bank_name',
        'bank_code',
        'swift_code',
        'address',
        'contact_number',
        'is_active',
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    // Scope for active banks
    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    // Relationship with bank deposits
    public function deposits()
    {
        return $this->hasMany(BankDeposit::class, 'bank_id');
    }
}
