<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BankDeposit extends Model
{
    use HasFactory;

    protected $fillable = [
        'deposit_number',
        'bank_name',
        'branch_name',
        'amount',
        'reference_number',
        'deposit_date',
        'status',
        'notes',
        'receipt_path',
        'deposited_by',
        'verified_by',
        'verified_at',
    ];

    protected $casts = [
        'deposit_date' => 'date',
        'amount' => 'decimal:2',
        'verified_at' => 'datetime',
    ];

    // Auto-generate deposit number
    protected static function boot()
    {
        parent::boot();

        static::creating(function ($deposit) {
            if (empty($deposit->deposit_number)) {
                $deposit->deposit_number = 'DEP-' . date('Y') . '-' . str_pad(static::count() + 1, 4, '0', STR_PAD_LEFT);
            }
        });
    }

    // Relationships
    public function depositedBy()
    {
        return $this->belongsTo(User::class, 'deposited_by');
    }

    public function verifiedBy()
    {
        return $this->belongsTo(User::class, 'verified_by');
    }
}
