<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BankDiscrepancy extends Model
{
    use HasFactory;

    protected $fillable = [
        'bank_reconciliation_line_id',
        'source',
        'txn_date',
        'description',
        'amount',
        'resolved',
        'resolved_at',
        'resolution_notes',
    ];

    protected $casts = [
        'txn_date' => 'date',
        'resolved' => 'boolean',
        'resolved_at' => 'datetime',
    ];

    public function line()
    {
        return $this->belongsTo(BankReconciliationLine::class, 'bank_reconciliation_line_id');
    }
}
