<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BankReconciliation extends Model
{
    use HasFactory;

    protected $fillable = [
        'bank_name',
        'statement_period',
        'uploaded_at',
    ];

    protected $casts = [
        'uploaded_at' => 'date',
    ];

    public function lines()
    {
        return $this->hasMany(BankReconciliationLine::class);
    }
}
