<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BankReconciliationLine extends Model
{
    use HasFactory;

    protected $fillable = [
        'bank_reconciliation_id',
        'txn_date',
        'description',
        'amount',
        'is_matched',
    ];

    protected $casts = [
        'txn_date' => 'date',
        'is_matched' => 'boolean',
    ];

    public function reconciliation()
    {
        return $this->belongsTo(BankReconciliation::class, 'bank_reconciliation_id');
    }
}
