<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Branch extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'manager',
        'location',
        'total_shipments',
        'avatar',
    ];

    /**
     * Get the riders for the branch.
     */
    public function riders()
    {
        return $this->hasMany(Rider::class);
    }
}
