<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Cheque extends Model
{
    use HasFactory;

    protected $fillable = [
        'bank_account_id',
        'cheque_number',
        'type',
        'payee',
        'amount',
        'issue_date',
        'due_date',
        'status',
        'deposit_date',
        'cleared_at',
        'notes',
    ];

    protected $casts = [
        'issue_date' => 'date',
        'due_date' => 'date',
        'deposit_date' => 'date',
        'cleared_at' => 'date',
    ];

    public function bankAccount()
    {
        return $this->belongsTo(BankAccount::class);
    }
}
