<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CodCollection extends Model
{
    use HasFactory;

    protected $fillable = [
        'rider_id',
        'collection_date',
        'total_parcels',
        'total_amount',
        'collected_amount',
        'pending_amount',
        'status',
        'notes',
        'verified_by',
        'verified_at',
    ];

    protected $casts = [
        'collection_date' => 'date',
        'total_amount' => 'decimal:2',
        'collected_amount' => 'decimal:2',
        'pending_amount' => 'decimal:2',
        'verified_at' => 'datetime',
    ];

    // Relationships
    public function rider()
    {
        return $this->belongsTo(User::class, 'rider_id');
    }

    public function verifiedBy()
    {
        return $this->belongsTo(User::class, 'verified_by');
    }
}
