<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CodPendingReport extends Model
{
    use HasFactory;

    protected $fillable = [
        'parcel_id',
        'rider_id',
        'cod_amount',
        'delivery_date',
        'due_date',
        'days_pending',
        'status',
        'notes',
        'collected_at',
    ];

    protected $casts = [
        'cod_amount' => 'decimal:2',
        'delivery_date' => 'date',
        'due_date' => 'date',
        'collected_at' => 'datetime',
    ];

    // Relationships
    public function parcel()
    {
        return $this->belongsTo(Parcel::class);
    }

    public function rider()
    {
        return $this->belongsTo(User::class, 'rider_id');
    }
}
