<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CodVarianceReport extends Model
{
    use HasFactory;

    protected $fillable = [
        'rider_id',
        'variance_date',
        'expected_amount',
        'collected_amount',
        'variance_amount',
        'percentage_variance',
        'variance_type',
        'status',
        'reason',
        'resolution_notes',
        'investigated_by',
        'resolved_by',
        'resolved_at',
    ];

    protected $casts = [
        'variance_date' => 'date',
        'expected_amount' => 'decimal:2',
        'collected_amount' => 'decimal:2',
        'variance_amount' => 'decimal:2',
        'percentage_variance' => 'decimal:2',
        'resolved_at' => 'datetime',
    ];

    // Relationships
    public function rider()
    {
        return $this->belongsTo(User::class, 'rider_id');
    }

    public function investigatedBy()
    {
        return $this->belongsTo(User::class, 'investigated_by');
    }

    public function resolvedBy()
    {
        return $this->belongsTo(User::class, 'resolved_by');
    }
}
