<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Complaint extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'parcel_id',
        'subject',
        'description',
        'status',
        'seller_id',
    ];

    /**
     * Get the parcel that owns the complaint.
     */
    public function parcel()
    {
        return $this->belongsTo(Parcel::class);
    }

    /**
     * Get the seller that owns the complaint.
     */
    public function seller()
    {
        return $this->belongsTo(User::class, 'seller_id');
    }
}
