<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ComplianceDocument extends Model
{
    use HasFactory;

    protected $fillable = [
        'title',
        'code',
        'category',
        'description',
        'content',
        'status',
        'effective_date',
        'expires_at',
        'is_required',
        'created_by',
        'updated_by',
        'notes',
    ];

    protected $casts = [
        'effective_date' => 'date',
        'expires_at' => 'date',
        'is_required' => 'boolean',
    ];
}