<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Contract extends Model
{
    use HasFactory;

    public function merchant()
    {
        return $this->belongsTo(User::class, 'merchant_id');
    }

    protected $fillable = [
        'title',
        'contract_number',
        'merchant_id',
        'start_date',
        'end_date',
        'status',
        'file_path',
        'notes',
    ];
}