<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Discount extends Model
{
    use HasFactory;

    protected $table = 'discount_rates';

    protected $fillable = [
        'name',
        'code',
        'type', // percentage or fixed
        'amount',
        'currency',
        'applies_to', // global, zone, merchant, service
        'target_code', // zone code, merchant id/code, service code
        'min_order_value',
        'max_discount_value',
        'effective_from',
        'effective_to',
        'status', // active, inactive, archived
        'notes',
    ];

    protected $casts = [
        'amount' => 'decimal:2',
        'min_order_value' => 'decimal:2',
        'max_discount_value' => 'decimal:2',
        'effective_from' => 'date',
        'effective_to' => 'date',
    ];
}