<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Div extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'code',
        'category',
        'owner',
        'status',
        'start_date',
        'end_date',
        'notes',
    ];

    protected $casts = [
        'start_date' => 'date',
        'end_date' => 'date',
    ];

    public function scopeSearch($query, $term)
    {
        $term = "%" . trim($term) . "%";
        return $query->where(function ($q) use ($term) {
            $q->where('name', 'like', $term)
              ->orWhere('code', 'like', $term)
              ->orWhere('category', 'like', $term)
              ->orWhere('owner', 'like', $term);
        });
    }

    public function scopeStatus($query, $status)
    {
        if (!$status) return $query;
        return $query->where('status', $status);
    }
}