<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Employee extends Model
{
    use HasFactory;

    protected $fillable = [
        'employee_id',
        'name',
        'email',
        'phone',
        'department',
        'designation',
        'date_of_joining',
        'salary',
        'user_id',
    ];

    protected $casts = [
        'date_of_joining' => 'date',
        'salary' => 'decimal:2',
    ];
}
