<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class IncomeTaxWithholding extends Model
{
    use HasFactory;

    protected $fillable = [
        'employee_id',
        'period',
        'gross_income',
        'taxable_income',
        'tax_withheld',
        'notes',
    ];

    public function employee()
    {
        return $this->belongsTo(Employee::class);
    }
}
