<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class InternalAudit extends Model
{
    use HasFactory;

    protected $fillable = [
        'title',
        'scope',
        'audit_date',
        'auditor',
        'status',
        'notes',
    ];

    protected $casts = [
        'audit_date' => 'date',
    ];

    public function findings()
    {
        return $this->hasMany(InternalAuditFinding::class);
    }
}
