<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class InternalAuditFinding extends Model
{
    use HasFactory;

    protected $fillable = [
        'internal_audit_id',
        'title',
        'detail',
        'severity',
        'resolved',
        'resolved_at',
        'resolution_notes',
    ];

    protected $casts = [
        'resolved' => 'boolean',
        'resolved_at' => 'datetime',
    ];

    public function audit()
    {
        return $this->belongsTo(InternalAudit::class, 'internal_audit_id');
    }
}
