<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Lead extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'company',
        'company_name',
        'contact_person',
        'email',
        'phone',
        'status',
        'user_id',
        'territory_id',
        'notes',
        'value',
    ];

    public function territory()
    {
        return $this->belongsTo(Territory::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
